package cx.threeg.dcms.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.InputType;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;

import cx.threeg.dcms.R;
import cx.threeg.dcms.core.Prefs;
import cx.threeg.dcms.core.Prefs;

public class ReaderActivity extends Activity {

    public static final String EXTRA_URL = "url";

    private WebView web;
    private ProgressBar bar;

    @Override protected void onCreate(Bundle savedInstanceState){
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_reader);
        web = (WebView)findViewById(R.id.web);
        bar = (ProgressBar)findViewById(R.id.progress);

        WebSettings s = web.getSettings();
        s.setJavaScriptEnabled(true); s.setDomStorageEnabled(true);
        CookieManager.getInstance().setAcceptCookie(true);

        web.setWebChromeClient(new WebChromeClient(){
            @Override public void onProgressChanged(WebView view, int newProgress){
                bar.setProgress(newProgress); bar.setVisibility(newProgress>=100?View.GONE:View.VISIBLE);
            }
        });
        web.setWebViewClient(new WebViewClient(){
            @Override public void onPageFinished(WebView view, String url){ injectReaderCss(); }
        });

        String url = getIntent().getStringExtra(EXTRA_URL);
        if (url==null) url = "https://3g.cx/";
        web.loadUrl(url);

        Button btnOpen = (Button)findViewById(R.id.btnOpenBrowser);
        if (btnOpen != null) {
            btnOpen.setOnClickListener(new View.OnClickListener(){ @Override public void onClick(View v){ 
                String u = web.getUrl(); Intent i = new Intent(Intent.ACTION_VIEW, Uri.parse(u)); startActivity(i);
            }});
        }

        Button btnReply = (Button)findViewById(R.id.btnReply);
        if (btnReply != null) {
            btnReply.setOnClickListener(new View.OnClickListener(){ @Override public void onClick(View v){ showReplyDialog(); }});
        }

        Button btnInput = (Button)findViewById(R.id.btnInputHelper);
        if (btnInput != null) {
            btnInput.setOnClickListener(new View.OnClickListener(){ @Override public void onClick(View v){ showInputHelper(); }});
        }
    }

    private void injectReaderCss(){
        if (!Prefs.enhancedTypo(this)) return;
        String css = "body{background:#0f1420;color:#eaeff7;font-size:16px;line-height:1.6;padding:10px}"
                   + "a{color:#9BB2FF} img{max-width:100%;} pre,code{white-space:pre-wrap;}"
                   + ".dcms-wrap{max-width:900px;margin:0 auto;} blockquote{opacity:.9;padding:.5em;border-left:3px solid #9BB2FF;background:rgba(255,255,255,.03)}";
        StringBuilder js = new StringBuilder();
        js.append("(function(){");
        js.append("var s=document.createElement('style');s.type='text/css';s.appendChild(document.createTextNode('");
        js.append(css.replace("'", "\'"));
        js.append("'));document.head.appendChild(s);");
        js.append("})();");
        web.loadUrl("javascript:" + js.toString());
    }

    private void showReplyDialog(){
        final EditText input = new EditText(this);
        input.setHint(getString(R.string.compose_hint));
        input.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_FLAG_MULTI_LINE);
        input.setMinLines(3);
        new AlertDialog.Builder(this)
                .setTitle(getString(R.string.reply))
                .setView(input)
                .setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener(){
                    @Override public void onClick(DialogInterface dialog, int which){
                        String txt = toJsString(input.getText().toString());
                        String js = "var f=document.querySelector('form textarea, form [name=message], form [name=content]');"
                                  + "if(f){f.value=" + txt + "; var e=document.createEvent('HTMLEvents');e.initEvent('input',true,true);f.dispatchEvent(e); var form=f.form; if(form) form.submit();}";
                        web.loadUrl("javascript:" + js);
                    }
                })
                .setNegativeButton(android.R.string.cancel, new DialogInterface.OnClickListener(){
                    @Override public void onClick(DialogInterface dialog, int which){}
                })
                .show();
    }

    private void showInputHelper(){
        if (!Prefs.enableInput(this)) return;
        final EditText input = new EditText(this);
        input.setHint(getString(R.string.compose_hint));
        input.setMinLines(3);
        new AlertDialog.Builder(this)
                .setTitle(getString(R.string.input_helper))
                .setView(input)
                .setPositiveButton(android.R.string.ok, new DialogInterface.OnClickListener(){
                    @Override public void onClick(DialogInterface dialog, int which){
                        String txt = toJsString(input.getText().toString());
                        String js = "var f=document.querySelector('textarea, input[type=text], input[type=search], input[type=password]');"
                                  + "if(f){f.focus(); f.value=" + txt + "; var e=document.createEvent('HTMLEvents');e.initEvent('input',true,true);f.dispatchEvent(e);}";
                        web.loadUrl("javascript:" + js);
                    }
                })
                .setNeutralButton("清空", new DialogInterface.OnClickListener(){
                    @Override public void onClick(DialogInterface dialog, int which){
                        String js = "var f=document.querySelector('textarea, input[type=text], input[type=search], input[type=password]'); if(f){f.focus(); f.value='';}";
                        web.loadUrl("javascript:" + js);
                    }
                })
                .setNegativeButton(android.R.string.cancel, new DialogInterface.OnClickListener(){
                    @Override public void onClick(DialogInterface dialog, int which){}
                })
                .show();
    }

    private String toJsString(String s){
        if (s == null) s = "";
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        for (int i=0;i<s.length();i++){
            char c = s.charAt(i);
            if (c == 92) { sb.append((char)92).append((char)92); }
            else if (c == 39) { sb.append((char)92).append("'"); }
            else if (c == 10) { sb.append((char)92).append("n"); }
            else if (c == 13) { /* skip */ }
            else { sb.append(c); }
        }
        sb.append("'");
        return sb.toString();
    }
}
